<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_admin
 *
 * @copyright   (C) 2018 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\Admin\Administrator\Extension;

use Joomla\CMS\Extension\BootableExtensionInterface;
use Joomla\CMS\Extension\MVCComponent;
use Joomla\CMS\HTML\HTMLRegistryAwareTrait;
use Joomla\Component\Admin\Administrator\Service\HTML\Configuration;
use Joomla\Component\Admin\Administrator\Service\HTML\Directory;
use Joomla\Component\Admin\Administrator\Service\HTML\PhpSetting;
use Joomla\Component\Admin\Administrator\Service\HTML\System;
use Psr\Container\ContainerInterface;

/**
 * Component class for com_admin
 *
 * @since  4.0.0
 */
class AdminComponent extends MVCComponent implements BootableExtensionInterface
{
    use HTMLRegistryAwareTrait;

    /**
     * Booting the extension. This is the function to set up the environment of the extension like
     * registering new class loaders, etc.
     *
     * If required, some initial set up can be done from services of the container, eg.
     * registering HTML services.
     *
     * @param   ContainerInterface  $container  The container
     *
     * @return  void
     *
     * @since   4.0.0
     */
    public function boot(ContainerInterface $container)
    {
        $this->getRegistry()->register('system', new System());
        $this->getRegistry()->register('phpsetting', new PhpSetting());
        $this->getRegistry()->register('directory', new Directory());
        $this->getRegistry()->register('configuration', new Configuration());
    }
}
